<?php
session_start();
require_once 'config/database.php';
require_once 'classes/Wishlist.php';
require_once 'includes/functions.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$database = new Database();
$db = $database->getConnection();
$wishlist = new Wishlist($db);

$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add_to_wishlist'])) {
        $wishlist->user_id = $_SESSION['user_id'];
        $wishlist->product_id = sanitizeInput($_POST['product_id']);
        if ($wishlist->addToWishlist()) {
            $message = 'Item added to wishlist';
        } else {
            $message = 'Failed to add item to wishlist';
        }
    } elseif (isset($_POST['remove_from_wishlist'])) {
        $wishlist->id = sanitizeInput($_POST['wishlist_id']);
        if ($wishlist->removeFromWishlist()) {
            $message = 'Item removed from wishlist';
        } else {
            $message = 'Failed to remove item from wishlist';
        }
    }
}

$wishlistItems = $wishlist->getWishlistItems($_SESSION['user_id']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Wishlist - Internext</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <main>
        <div class="container">
            <div class="wishlist-page">
                <h1>My Wishlist</h1>

                <?php if ($message): ?>
                    <div class="alert alert-success"><?php echo $message; ?></div>
                <?php endif; ?>

                <?php if ($wishlistItems->rowCount() > 0): ?>
                    <div class="wishlist-items">
                        <?php while ($item = $wishlistItems->fetch(PDO::FETCH_ASSOC)):
                            $images = json_decode($item['images'], true);
                            $firstImage = $images ? $images[0] : 'placeholder.jpg';
                        ?>
                            <div class="wishlist-item">
                                <img src="uploads/<?php echo $firstImage; ?>" alt="<?php echo $item['name']; ?>" onerror="this.src='assets/images/placeholder.jpg'">
                                <div class="item-details">
                                    <h3><?php echo $item['name']; ?></h3>
                                    <div class="price"><?php echo formatPrice($item['price']); ?></div>
                                </div>
                                <div class="item-actions">
                                    <a href="product.php?id=<?php echo $item['product_id']; ?>" class="btn btn-primary">View Details</a>
                                    <button class="btn btn-secondary add-to-cart" data-product-id="<?php echo $item['product_id']; ?>">Add to Cart</button>
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="wishlist_id" value="<?php echo $item['id']; ?>">
                                        <button type="submit" name="remove_from_wishlist" class="btn btn-small btn-danger">Remove</button>
                                    </form>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                <?php else: ?>
                    <div class="empty-wishlist">
                        <h2>Your wishlist is empty</h2>
                        <p>Add products to your wishlist to keep track of items you're interested in!</p>
                        <a href="products.php" class="btn btn-primary">Browse Products</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <?php include 'includes/footer.php'; ?>

    <script src="assets/js/main.js"></script>
</body>
</html>