<?php
session_start();
require_once 'config/database.php';
require_once 'classes/Product.php';
require_once 'classes/Category.php';
require_once 'includes/functions.php';

$database = new Database();
$db = $database->getConnection();
$product = new Product($db);
$category = new Category($db);

// Handle search
$searchTerm = isset($_GET['search']) ? sanitizeInput($_GET['search']) : '';
$categoryFilter = isset($_GET['category']) ? sanitizeInput($_GET['category']) : '';

if ($searchTerm) {
    $products = $product->search($searchTerm);
} elseif ($categoryFilter) {
    $products = $product->readByCategory($categoryFilter);
} else {
    $products = $product->read();
}

$categories = $category->read();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Products - Internext</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <main>
        <div class="container">
            <div class="products-page">
                <aside class="filters">
                    <h3>Filters</h3>
                    <form method="GET" action="">
                        <div class="filter-group">
                            <label for="search">Search:</label>
                            <input type="text" id="search" name="search" value="<?php echo $searchTerm; ?>" placeholder="Search products...">
                        </div>
                        <div class="filter-group">
                            <label for="category">Category:</label>
                            <select id="category" name="category">
                                <option value="">All Categories</option>
                                <?php while ($cat = $categories->fetch(PDO::FETCH_ASSOC)): ?>
                                    <option value="<?php echo $cat['id']; ?>" <?php echo $categoryFilter == $cat['id'] ? 'selected' : ''; ?>>
                                        <?php echo $cat['name']; ?>
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary">Filter</button>
                        <a href="products.php" class="btn btn-secondary">Clear Filters</a>
                    </form>
                </aside>

                <div class="products-content">
                    <div class="products-header">
                        <h1>Our Products</h1>
                        <p>Discover our amazing collection</p>
                    </div>

                    <div class="product-grid">
                        <?php while ($row = $products->fetch(PDO::FETCH_ASSOC)):
                            $images = json_decode($row['images'], true);
                            $firstImage = $images ? $images[0] : 'placeholder.jpg';
                        ?>
                            <div class="product-card">
                                <div class="product-image-container">
                                    <img src="uploads/<?php echo $firstImage; ?>" alt="<?php echo $row['name']; ?>" onerror="this.src='assets/images/placeholder.jpg'">
                                    <div class="product-overlay">
                                        <button class="btn-icon quick-view" data-product-id="<?php echo $row['id']; ?>" title="Quick View">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <?php if (isLoggedIn()): ?>
                                            <button class="btn-icon add-to-wishlist" data-product-id="<?php echo $row['id']; ?>" title="Add to Wishlist">
                                                <i class="far fa-heart"></i>
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <h3><?php echo $row['name']; ?></h3>
                                <p><?php echo substr($row['description'], 0, 100) . '...'; ?></p>
                                <div class="price"><?php echo formatPrice($row['price']); ?></div>
                                <div class="product-actions">
                                    <a href="product.php?id=<?php echo $row['id']; ?>" class="btn btn-primary">View Details</a>
                                    <?php if (isLoggedIn()): ?>
                                        <button class="btn btn-secondary add-to-cart" data-product-id="<?php echo $row['id']; ?>">Add to Cart</button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Quick View Modal -->
    <div id="quick-view-modal" class="modal">
        <div class="modal-content">
            <span class="close-modal">&times;</span>
            <div id="modal-product-content">
                <!-- Product content will be loaded here -->
            </div>
        </div>
    </div>
    <?php include 'includes/footer.php'; ?>

    <script src="assets/js/main.js"></script>
</body>
</html>