<?php
session_start();
require_once 'config/database.php';
require_once 'classes/Product.php';
require_once 'classes/Wishlist.php';
require_once 'includes/functions.php';

if (!isset($_GET['id'])) {
    redirect('products.php');
}

$quickView = isset($_GET['quick_view']) && $_GET['quick_view'] == '1';

$database = new Database();
$db = $database->getConnection();
$product = new Product($db);
$wishlist = new Wishlist($db);

$product->id = $_GET['id'];
$product->readOne();

$images = is_array($product->images) ? $product->images : json_decode($product->images, true);
$inWishlist = false;

if (isLoggedIn()) {
    $inWishlist = $wishlist->isInWishlist($_SESSION['user_id'], $product->id);
}
?>

<?php if (!$quickView): ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $product->name; ?> - Internext</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
<?php endif; ?>

<?php if ($quickView): ?>
<div class="quick-view-content">
    <div class="quick-view-header">
        <h2><?php echo $product->name; ?></h2>
    </div>
    <div class="quick-view-body">
        <div class="quick-view-images">
            <?php if ($images && count($images) > 0): ?>
                <div class="main-image">
                    <img id="mainImage" src="uploads/<?php echo $images[0]; ?>" alt="<?php echo $product->name; ?>" onerror="this.src='assets/images/placeholder.jpg'">
                </div>
                <?php if (count($images) > 1): ?>
                    <div class="thumbnail-images">
                        <?php foreach ($images as $image): ?>
                            <img src="uploads/<?php echo $image; ?>" alt="<?php echo $product->name; ?>" onclick="changeImage(this.src)" onerror="this.src='assets/images/placeholder.jpg'">
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            <?php else: ?>
                <div class="main-image">
                    <img src="assets/images/placeholder.jpg" alt="<?php echo $product->name; ?>">
                </div>
            <?php endif; ?>
        </div>

        <div class="quick-view-info">
            <div class="price"><?php echo formatPrice($product->price); ?></div>
            <div class="stock">Stock: <?php echo $product->stock_quantity; ?> available</div>
            <div class="description">
                <p><?php echo substr($product->description, 0, 150) . (strlen($product->description) > 150 ? '...' : ''); ?></p>
            </div>

            <?php if (isLoggedIn()): ?>
                <div class="product-actions">
                    <button class="btn btn-primary add-to-cart" data-product-id="<?php echo $product->id; ?>">Add to Cart</button>
                    <button class="btn btn-secondary <?php echo $inWishlist ? 'remove-from-wishlist' : 'add-to-wishlist'; ?>" data-product-id="<?php echo $product->id; ?>">
                        <?php echo $inWishlist ? 'Remove from Wishlist' : 'Add to Wishlist'; ?>
                    </button>
                    <a href="product.php?id=<?php echo $product->id; ?>" class="btn btn-outline">View Full Details</a>
                </div>
            <?php else: ?>
                <p>Please <a href="login.php">login</a> to add items to cart or wishlist.</p>
                <a href="product.php?id=<?php echo $product->id; ?>" class="btn btn-outline">View Full Details</a>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php else: ?>
    <main>
        <div class="container">
            <div class="product-detail">
                <div class="product-images">
                    <?php if ($images && count($images) > 0): ?>
                        <div class="main-image">
                            <img id="mainImage" src="uploads/<?php echo $images[0]; ?>" alt="<?php echo $product->name; ?>" onerror="this.src='assets/images/placeholder.jpg'">
                        </div>
                        <?php if (count($images) > 1): ?>
                            <div class="thumbnail-images">
                                <?php foreach ($images as $image): ?>
                                    <img src="uploads/<?php echo $image; ?>" alt="<?php echo $product->name; ?>" onclick="changeImage(this.src)" onerror="this.src='assets/images/placeholder.jpg'">
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="main-image">
                            <img src="assets/images/placeholder.jpg" alt="<?php echo $product->name; ?>">
                        </div>
                    <?php endif; ?>
                </div>

                <div class="product-info">
                    <h1><?php echo $product->name; ?></h1>
                    <div class="price"><?php echo formatPrice($product->price); ?></div>
                    <div class="stock">Stock: <?php echo $product->stock_quantity; ?> available</div>
                    <div class="description">
                        <h3>Description</h3>
                        <p><?php echo $product->description; ?></p>
                    </div>

                    <?php if (isLoggedIn()): ?>
                        <div class="product-actions">
                            <button class="btn btn-primary add-to-cart" data-product-id="<?php echo $product->id; ?>">Add to Cart</button>
                            <button class="btn btn-secondary <?php echo $inWishlist ? 'remove-from-wishlist' : 'add-to-wishlist'; ?>" data-product-id="<?php echo $product->id; ?>">
                                <?php echo $inWishlist ? 'Remove from Wishlist' : 'Add to Wishlist'; ?>
                            </button>
                        </div>
                    <?php else: ?>
                        <p>Please <a href="login.php">login</a> to add items to cart or wishlist.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </main>

    <?php include 'includes/footer.php'; ?>

    <script src="assets/js/main.js"></script>
    <script>
        function changeImage(src) {
            document.getElementById('mainImage').src = src;
        }
    </script>
</body>
</html>
<?php endif; ?>