<?php
require_once 'config/database.php';
require_once 'classes/Order.php';

$database = new Database();
$db = $database->getConnection();
$order = new Order($db);

// Get Paystack webhook data
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Verify webhook signature (recommended for production)
$secret = PAYSTACK_SECRET_KEY;
$signature = $_SERVER['HTTP_X_PAYSTACK_SIGNATURE'] ?? '';

$computedSignature = hash_hmac('sha512', $input, $secret);

if ($signature !== $computedSignature) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Invalid signature']);
    exit();
}

if ($data && isset($data['event'])) {
    switch ($data['event']) {
        case 'charge.success':
            $paymentData = $data['data'];
            $reference = $paymentData['reference'];

            // Find and update order
            $query = "SELECT id FROM orders WHERE payment_reference = ?";
            $stmt = $db->prepare($query);
            $stmt->bindParam(1, $reference);
            $stmt->execute();

            if ($stmt->rowCount() > 0) {
                $row = $stmt->fetch(PDO::FETCH_ASSOC);
                $order->id = $row['id'];
                $order->status = 'processing';
                $order->update();

                error_log("Paystack payment successful: " . $reference);
            }
            break;

        case 'charge.failed':
            $paymentData = $data['data'];
            $reference = $paymentData['reference'];

            // Update order status to failed
            $query = "SELECT id FROM orders WHERE payment_reference = ?";
            $stmt = $db->prepare($query);
            $stmt->bindParam(1, $reference);
            $stmt->execute();

            if ($stmt->rowCount() > 0) {
                $row = $stmt->fetch(PDO::FETCH_ASSOC);
                $order->id = $row['id'];
                $order->status = 'cancelled';
                $order->update();

                error_log("Paystack payment failed: " . $reference);
            }
            break;
    }
}

http_response_code(200);
echo json_encode(['status' => 'success']);
?>