<?php
session_start();
require_once 'config/database.php';
require_once 'classes/Order.php';
require_once 'includes/functions.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$database = new Database();
$db = $database->getConnection();
$order = new Order($db);

$message = '';

if (isset($_GET['reference']) && isset($_GET['order_id'])) {
    $reference = $_GET['reference'];
    $order_id = $_GET['order_id'];

    // Verify payment with Paystack API using the Paystack class
    require_once 'classes/Paystack.php';
    $paystack = new Paystack();
    $verifyResult = $paystack->verifyTransaction($reference);

    if ($verifyResult['success']) {
        // Payment was successful
        $order->id = $order_id;
        $order->status = 'processing';
        if ($order->update()) {
            $message = 'Payment successful! Your order is being processed.';
        } else {
            $message = 'Payment recorded, but there was an issue updating your order status.';
        }
    } else {
        $message = 'Payment verification failed. Please contact support.';
    }
} else {
    redirect('orders.php');
}

$order->readOne();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Success - Internext</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <main>
        <div class="container">
            <div class="payment-success">
                <h1>Payment Successful!</h1>

                <div class="success-message">
                    <?php if ($message): ?>
                        <div class="alert alert-success"><?php echo $message; ?></div>
                    <?php endif; ?>
                </div>

                <div class="order-details">
                    <h2>Order Details</h2>
                    <p><strong>Order ID:</strong> <?php echo $order->id; ?></p>
                    <p><strong>Total Amount:</strong> <?php echo formatPrice($order->total_amount); ?></p>
                    <p><strong>Payment Reference:</strong> <?php echo $order->payment_reference; ?></p>
                    <p><strong>Status:</strong> <?php echo ucfirst($order->status); ?></p>
                    <p><strong>Shipping Address:</strong> <?php echo $order->shipping_address; ?></p>
                </div>

                <div class="next-steps">
                    <h2>What happens next?</h2>
                    <ul>
                        <li>You will receive an email confirmation shortly</li>
                        <li>Your order will be processed within 1-2 business days</li>
                        <li>You will receive shipping updates via email</li>
                        <li>Delivery typically takes 3-5 business days</li>
                    </ul>
                </div>

                <div class="actions">
                    <a href="orders.php" class="btn btn-primary">View My Orders</a>
                    <a href="products.php" class="btn btn-secondary">Continue Shopping</a>
                </div>
            </div>
        </div>
    </main>

    <?php include 'includes/footer.php'; ?>

    <script src="assets/js/main.js"></script>
</body>
</html>