<?php
session_start();
require_once 'config/database.php';
require_once 'classes/Order.php';
require_once 'includes/functions.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

if (!isset($_GET['order_id'])) {
    redirect('orders.php');
}

$database = new Database();
$db = $database->getConnection();
$order = new Order($db);

$order->id = $_GET['order_id'];
$order->readOne();

// Verify order belongs to user
if ($order->user_id != $_SESSION['user_id']) {
    redirect('orders.php');
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment - Internext</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="https://js.paystack.co/v1/inline.js"></script>
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <main>
        <div class="container">
            <div class="payment-page">
                <h1>Complete Your Payment</h1>

                <div class="order-summary">
                    <h2>Order Summary</h2>
                    <p><strong>Order ID:</strong> <?php echo $order->id; ?></p>
                    <p><strong>Total Amount:</strong> <?php echo formatPrice($order->total_amount); ?></p>
                    <p><strong>Payment Reference:</strong> <?php echo $order->payment_reference; ?></p>
                </div>

                <div class="payment-form">
                    <h2>Payment Details</h2>
                    <form id="paymentForm">
                        <div class="form-group">
                            <label for="email">Email:</label>
                            <input type="email" id="email" value="<?php echo $_SESSION['checkout_email'] ?? $_SESSION['user_email'] ?? ''; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="phone">Phone:</label>
                            <input type="tel" id="phone" value="<?php echo $_SESSION['checkout_phone'] ?? ''; ?>" readonly>
                        </div>
                        <div class="form-group">
                            <label for="amount">Amount:</label>
                            <input type="text" id="amount" value="<?php echo $order->total_amount; ?>" readonly>
                        </div>
                        <button type="button" onclick="payWithPaystack()" class="btn btn-primary">Pay Now</button>
                    </form>
                </div>
            </div>
        </div>
    </main>

    <?php include 'includes/footer.php'; ?>

    <script>
        function payWithPaystack() {
            const email = document.getElementById('email').value;
            const amount = document.getElementById('amount').value;

            if (!email || !amount) {
                alert('Please fill in all required fields');
                return;
            }

            console.log('Initializing Paystack payment...');
            console.log('Email:', email);
            console.log('Amount:', amount);
            console.log('Key:', '<?php echo PAYSTACK_PUBLIC_KEY; ?>');

            const handler = PaystackPop.setup({
                key: '<?php echo PAYSTACK_PUBLIC_KEY; ?>',
                email: email,
                amount: parseFloat(amount) * 100, // Paystack expects amount in cents
                currency: 'KES',
                ref: '<?php echo $order->payment_reference; ?>',
                callback: function(response) {
                    console.log('Payment successful:', response);
                    // Payment successful
                    window.location.href = 'payment_success.php?reference=' + response.reference + '&order_id=<?php echo $order->id; ?>';
                },
                onClose: function() {
                    console.log('Payment modal closed');
                    alert('Payment cancelled');
                }
            });

            console.log('Opening Paystack iframe...');
            handler.openIframe();
        }

        // Add form validation
        document.getElementById('paymentForm').addEventListener('submit', function(e) {
            e.preventDefault();
            payWithPaystack();
        });
    </script>
</body>
</html>