<?php
session_start();
require_once 'config/database.php';
require_once 'classes/Order.php';
require_once 'classes/OrderItem.php';
require_once 'includes/functions.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$database = new Database();
$db = $database->getConnection();
$order = new Order($db);
$orderItem = new OrderItem($db);

$userOrders = $order->getUserOrders($_SESSION['user_id']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Orders - Internext</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <main>
        <div class="container">
            <div class="orders-page">
                <h1>My Orders</h1>

                <?php if ($userOrders->rowCount() > 0): ?>
                    <div class="orders-list">
                        <?php while ($orderData = $userOrders->fetch(PDO::FETCH_ASSOC)): ?>
                            <div class="order-card">
                                <div class="order-header">
                                    <h3>Order #<?php echo $orderData['id']; ?></h3>
                                    <span class="order-status status-<?php echo $orderData['status']; ?>"><?php echo ucfirst($orderData['status']); ?></span>
                                </div>
                                <div class="order-details">
                                    <p><strong>Total:</strong> <?php echo formatPrice($orderData['total_amount']); ?></p>
                                    <p><strong>Date:</strong> <?php echo date('M d, Y H:i', strtotime($orderData['created_at'])); ?></p>
                                    <p><strong>Payment Ref:</strong> <?php echo $orderData['payment_reference']; ?></p>
                                </div>
                                <div class="order-actions">
                                    <a href="order_details.php?id=<?php echo $orderData['id']; ?>" class="btn btn-primary">View Details</a>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                <?php else: ?>
                    <div class="empty-orders">
                        <h2>You haven't placed any orders yet</h2>
                        <p>Start shopping to see your orders here!</p>
                        <a href="products.php" class="btn btn-primary">Browse Products</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <?php include 'includes/footer.php'; ?>

    <script src="assets/js/main.js"></script>
</body>
</html>