<?php
session_start();
require_once 'config/database.php';
require_once 'classes/Order.php';
require_once 'classes/OrderItem.php';
require_once 'includes/functions.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

if (!isset($_GET['id'])) {
    redirect('orders.php');
}

$database = new Database();
$db = $database->getConnection();
$order = new Order($db);
$orderItem = new OrderItem($db);

$order->id = $_GET['id'];
$order->readOne();

// Verify order belongs to user
if ($order->user_id != $_SESSION['user_id']) {
    redirect('orders.php');
}

$orderItems = $orderItem->getOrderItems($order->id);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Details - Internext</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <main>
        <div class="container">
            <div class="order-details-page">
                <h1>Order Details #<?php echo $order->id; ?></h1>

                <div class="order-info">
                    <div class="info-section">
                        <h2>Order Information</h2>
                        <p><strong>Order ID:</strong> <?php echo $order->id; ?></p>
                        <p><strong>Total Amount:</strong> <?php echo formatPrice($order->total_amount); ?></p>
                        <p><strong>Status:</strong> <span class="status-<?php echo $order->status; ?>"><?php echo ucfirst($order->status); ?></span></p>
                        <p><strong>Payment Reference:</strong> <?php echo $order->payment_reference; ?></p>
                        <p><strong>Order Date:</strong> <?php echo date('M d, Y H:i', strtotime($order->created_at)); ?></p>
                    </div>

                    <div class="info-section">
                        <h2>Shipping Information</h2>
                        <p><?php echo nl2br($order->shipping_address); ?></p>
                    </div>
                </div>

                <div class="order-items">
                    <h2>Order Items</h2>
                    <div class="items-list">
                        <?php while ($item = $orderItems->fetch(PDO::FETCH_ASSOC)):
                            $images = json_decode($item['images'], true);
                            $firstImage = $images ? $images[0] : 'placeholder.jpg';
                        ?>
                            <div class="order-item">
                                <img src="uploads/<?php echo $firstImage; ?>" alt="<?php echo $item['name']; ?>" onerror="this.src='assets/images/placeholder.jpg'">
                                <div class="item-details">
                                    <h3><?php echo $item['name']; ?></h3>
                                    <p>Quantity: <?php echo $item['quantity']; ?></p>
                                    <p>Price: <?php echo formatPrice($item['price']); ?></p>
                                </div>
                                <div class="item-total"><?php echo formatPrice($item['quantity'] * $item['price']); ?></div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>

                <div class="order-actions">
                    <a href="orders.php" class="btn btn-secondary">Back to Orders</a>
                    <?php if ($order->status === 'delivered'): ?>
                        <button class="btn btn-primary">Write Review</button>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </main>

    <?php include 'includes/footer.php'; ?>

    <script src="assets/js/main.js"></script>
</body>
</html>