<?php
session_start();
require_once 'config/database.php';
require_once 'classes/Product.php';
require_once 'classes/Category.php';
require_once 'includes/functions.php';

$database = new Database();
$db = $database->getConnection();
$product = new Product($db);
$category = new Category($db);

// Get featured products (latest 8)
$featuredProducts = $product->read();
$categories = $category->read();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Internext - Online Shopping</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <main>
        <!-- Hero Section -->
        <section class="hero">
            <div class="hero-content">
                <h1>Welcome to Internext</h1>
                <p>Discover amazing products at great prices</p>
                <a href="#products" class="btn btn-primary">Shop Now</a>
            </div>
        </section>

        <!-- Categories Section -->
        <section class="categories">
            <div class="container">
                <h2>Shop by Category</h2>
                <div class="category-grid">
                    <?php while ($cat = $categories->fetch(PDO::FETCH_ASSOC)): ?>
                        <div class="category-card">
                            <h3><?php echo $cat['name']; ?></h3>
                            <p><?php echo $cat['description']; ?></p>
                            <a href="products.php?category=<?php echo $cat['id']; ?>" class="btn btn-secondary">Browse</a>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </section>

        <!-- Featured Products Section -->
        <section id="products" class="featured-products">
            <div class="container">
                <h2>Featured Products</h2>
                <div class="product-grid">
                    <?php
                    $count = 0;
                    while ($row = $featuredProducts->fetch(PDO::FETCH_ASSOC)):
                        if (!$row) break; // Exit if no more rows
                        $images = json_decode($row['images'], true);
                        $firstImage = $images ? $images[0] : 'placeholder.jpg';
                        if ($count >= 8) break; // Limit to 8 products
                    ?>
                        <div class="product-card">
                            <div class="product-image-container">
                                <img src="uploads/<?php echo $firstImage; ?>" alt="<?php echo $row['name']; ?>" onerror="this.src='assets/images/placeholder.jpg'">
                                <div class="product-overlay">
                                    <button class="btn-icon quick-view" data-product-id="<?php echo $row['id']; ?>" title="Quick View">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                    <?php if (isLoggedIn()): ?>
                                        <button class="btn-icon add-to-wishlist" data-product-id="<?php echo $row['id']; ?>" title="Add to Wishlist">
                                            <i class="far fa-heart"></i>
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <h3><?php echo $row['name']; ?></h3>
                            <p><?php echo substr($row['description'], 0, 100) . '...'; ?></p>
                            <div class="price"><?php echo formatPrice($row['price']); ?></div>
                            <div class="product-actions">
                                <a href="product.php?id=<?php echo $row['id']; ?>" class="btn btn-primary">View Details</a>
                                <?php if (isLoggedIn()): ?>
                                    <button class="btn btn-secondary add-to-cart" data-product-id="<?php echo $row['id']; ?>">Add to Cart</button>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php
                        $count++;
                    endwhile;
                    ?>
                </div>
            </div>
        </section>
    </main>

    <?php include 'includes/footer.php'; ?>

    <script src="assets/js/main.js"></script>
</body>
</html>
    <!-- Quick View Modal -->
    <div id="quick-view-modal" class="modal">
        <div class="modal-content">
            <span class="close-modal">&times;</span>
            <div id="modal-product-content">
                <!-- Product content will be loaded here -->
            </div>
        </div>
    </div>