<?php
require_once __DIR__ . '/../config/database.php';

class Wishlist {
    private $conn;
    private $table_name = 'wishlist';

    public $id;
    public $user_id;
    public $product_id;
    public $created_at;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function addToWishlist() {
        $query = "INSERT INTO " . $this->table_name . " SET user_id=:user_id, product_id=:product_id";
        $stmt = $this->conn->prepare($query);

        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $this->product_id = htmlspecialchars(strip_tags($this->product_id));

        $stmt->bindParam(":user_id", $this->user_id);
        $stmt->bindParam(":product_id", $this->product_id);

        if($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function getWishlistItems($user_id) {
        $query = "SELECT w.id, w.product_id, p.name, p.price, p.images FROM " . $this->table_name . " w LEFT JOIN products p ON w.product_id = p.id WHERE w.user_id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $user_id);
        $stmt->execute();
        return $stmt;
    }

    public function removeFromWishlist() {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);

        if($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function isInWishlist($user_id, $product_id) {
        $query = "SELECT id FROM " . $this->table_name . " WHERE user_id = ? AND product_id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $user_id);
        $stmt->bindParam(2, $product_id);
        $stmt->execute();

        return $stmt->rowCount() > 0;
    }
}
?>