<?php
require_once __DIR__ . '/../config/config.php';

class Paystack {
    private $secretKey;
    private $publicKey;
    private $paymentUrl;

    public function __construct() {
        $this->secretKey = PAYSTACK_SECRET_KEY;
        $this->publicKey = PAYSTACK_PUBLIC_KEY;
        $this->paymentUrl = 'https://api.paystack.co';
    }

    public function initializePayment($email, $amount, $reference, $callback_url = null) {
        $url = $this->paymentUrl . "/transaction/initialize";

        $data = array(
            'email' => $email,
            'amount' => $amount * 100, // Convert to cents for KES
            'reference' => $reference,
            'currency' => 'KES', // Specify Kenyan Shilling
            'callback_url' => $callback_url ?: SITE_URL . '/payment_success.php'
        );

        $response = $this->makeRequest($url, $data);

        if ($response && $response['status']) {
            return [
                'success' => true,
                'authorization_url' => $response['data']['authorization_url'],
                'access_code' => $response['data']['access_code'],
                'reference' => $reference
            ];
        }

        return ['success' => false, 'message' => 'Payment initialization failed'];
    }

    public function verifyTransaction($reference) {
        $url = $this->paymentUrl . "/transaction/verify/" . $reference;

        $response = $this->makeGetRequest($url);

        if ($response && $response['status'] && $response['data']['status'] === 'success') {
            return [
                'success' => true,
                'data' => $response['data']
            ];
        }

        return ['success' => false, 'message' => 'Transaction verification failed'];
    }

    private function makeRequest($url, $data) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: Bearer ' . $this->secretKey,
            'Content-Type: application/json',
            'Cache-Control: no-cache'
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($response === false) {
            return false;
        }

        return json_decode($response, true);
    }

    private function makeGetRequest($url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: Bearer ' . $this->secretKey,
            'Cache-Control: no-cache'
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($response === false) {
            return false;
        }

        return json_decode($response, true);
    }

    public function getPublicKey() {
        return $this->publicKey;
    }
}
?>