<?php
require_once __DIR__ . '/../config/database.php';

class Order {
    private $conn;
    private $table_name = 'orders';

    public $id;
    public $user_id;
    public $user_name;
    public $total_amount;
    public $status;
    public $payment_reference;
    public $email;
    public $phone;
    public $shipping_address;
    public $created_at;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function create() {
        $query = "INSERT INTO " . $this->table_name . " SET user_id=:user_id, total_amount=:total_amount, status=:status, payment_reference=:payment_reference, email=:email, phone=:phone, shipping_address=:shipping_address";
        $stmt = $this->conn->prepare($query);

        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $this->total_amount = htmlspecialchars(strip_tags($this->total_amount));
        $this->status = htmlspecialchars(strip_tags($this->status));
        $this->payment_reference = htmlspecialchars(strip_tags($this->payment_reference));
        $this->email = htmlspecialchars(strip_tags($this->email));
        $this->phone = htmlspecialchars(strip_tags($this->phone));
        $this->shipping_address = htmlspecialchars(strip_tags($this->shipping_address));

        $stmt->bindParam(":user_id", $this->user_id);
        $stmt->bindParam(":total_amount", $this->total_amount);
        $stmt->bindParam(":status", $this->status);
        $stmt->bindParam(":payment_reference", $this->payment_reference);
        $stmt->bindParam(":email", $this->email);
        $stmt->bindParam(":phone", $this->phone);
        $stmt->bindParam(":shipping_address", $this->shipping_address);

        if($stmt->execute()) {
            $this->id = $this->conn->lastInsertId();
            return true;
        }
        return false;
    }

    public function read() {
        $query = "SELECT o.id, o.user_id, o.total_amount, o.status, o.payment_reference, o.email, o.phone, o.shipping_address, o.created_at, u.name as user_name FROM " . $this->table_name . " o LEFT JOIN users u ON o.user_id = u.id ORDER BY o.created_at DESC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function readOne() {
        $query = "SELECT o.id, o.user_id, o.total_amount, o.status, o.payment_reference, o.email, o.phone, o.shipping_address, o.created_at, u.name as user_name FROM " . $this->table_name . " o LEFT JOIN users u ON o.user_id = u.id WHERE o.id = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        $this->user_id = $row['user_id'];
        $this->user_name = $row['user_name'];
        $this->total_amount = $row['total_amount'];
        $this->status = $row['status'];
        $this->payment_reference = $row['payment_reference'];
        $this->email = $row['email'];
        $this->phone = $row['phone'];
        $this->shipping_address = $row['shipping_address'];
        $this->created_at = $row['created_at'];
    }

    public function update() {
        $query = "UPDATE " . $this->table_name . " SET status=:status WHERE id=:id";
        $stmt = $this->conn->prepare($query);

        $this->status = htmlspecialchars(strip_tags($this->status));
        $this->id = htmlspecialchars(strip_tags($this->id));

        $stmt->bindParam(":status", $this->status);
        $stmt->bindParam(":id", $this->id);

        if($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function getUserOrders($user_id) {
        $query = "SELECT id, total_amount, status, payment_reference, email, phone, shipping_address, created_at FROM " . $this->table_name . " WHERE user_id = ? ORDER BY created_at DESC";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $user_id);
        $stmt->execute();
        return $stmt;
    }
}
?>