<?php
session_start();
require_once 'config/database.php';
require_once 'config/config.php';
require_once 'classes/Cart.php';
require_once 'classes/Order.php';
require_once 'classes/OrderItem.php';
require_once 'includes/functions.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$database = new Database();
$db = $database->getConnection();
$cart = new Cart($db);
$order = new Order($db);
$orderItem = new OrderItem($db);

$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $cartItems = $cart->getCartItems($_SESSION['user_id']);
    $cartTotal = $cart->getCartTotal($_SESSION['user_id']);

    if ($cartItems->rowCount() > 0) {
        // Store customer information in session for payment
        $_SESSION['checkout_email'] = sanitizeInput($_POST['email']);
        $_SESSION['checkout_phone'] = sanitizeInput($_POST['phone']);
        $_SESSION['checkout_address'] = sanitizeInput($_POST['shipping_address']);

        // Create order
        $order->user_id = $_SESSION['user_id'];
        $order->total_amount = $cartTotal;
        $order->status = 'pending';
        $order->payment_reference = 'PAY_' . time() . '_' . rand(1000, 9999);
        $order->email = $_SESSION['checkout_email'];
        $order->phone = $_SESSION['checkout_phone'];
        $order->shipping_address = $_SESSION['checkout_address'];

        if ($order->create()) {
            // Add order items
            while ($item = $cartItems->fetch(PDO::FETCH_ASSOC)) {
                $orderItem->order_id = $order->id;
                $orderItem->product_id = $item['product_id'];
                $orderItem->quantity = $item['quantity'];
                $orderItem->price = $item['price'];
                $orderItem->create();
            }

            // Clear cart
            $cart->clearCart($_SESSION['user_id']);

            // Initialize Paystack payment using the proper API approach
            require_once 'classes/Paystack.php';
            $paystack = new Paystack();

            $result = $paystack->initializePayment(
                $_SESSION['checkout_email'],
                $cartTotal,
                $order->payment_reference,
                SITE_URL . "/payment_success.php?reference=" . $order->payment_reference . "&order_id=" . $order->id
            );

            if ($result['success']) {
                redirect($result['authorization_url']);
            } else {
                $message = 'Failed to initialize payment. Please try again.';
            }
        } else {
            $message = 'Failed to create order';
        }
    } else {
        $message = 'Your cart is empty';
    }
}

$cartItems = $cart->getCartItems($_SESSION['user_id']);
$cartTotal = $cart->getCartTotal($_SESSION['user_id']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Checkout - Internext</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <main>
        <div class="container">
            <div class="checkout-page">
                <h1>Checkout</h1>

                <?php if ($message): ?>
                    <div class="alert alert-error"><?php echo $message; ?></div>
                <?php endif; ?>

                <?php if ($cartItems->rowCount() > 0): ?>
                    <div class="checkout-content">
                        <div class="order-summary">
                            <h2>Order Summary</h2>
                            <div class="cart-items">
                                <?php while ($item = $cartItems->fetch(PDO::FETCH_ASSOC)):
                                    $images = json_decode($item['images'], true);
                                    $firstImage = $images ? $images[0] : 'placeholder.jpg';
                                ?>
                                    <div class="cart-item">
                                        <img src="uploads/<?php echo $firstImage; ?>" alt="<?php echo $item['name']; ?>" onerror="this.src='assets/images/placeholder.jpg'">
                                        <div class="item-details">
                                            <h4><?php echo $item['name']; ?></h4>
                                            <p>Quantity: <?php echo $item['quantity']; ?></p>
                                            <p>Price: <?php echo formatPrice($item['price']); ?></p>
                                        </div>
                                        <div class="item-total"><?php echo formatPrice($item['quantity'] * $item['price']); ?></div>
                                    </div>
                                <?php endwhile; ?>
                            </div>
                            <div class="order-total">
                                <strong>Total: <?php echo formatPrice($cartTotal); ?></strong>
                            </div>
                        </div>

                        <div class="checkout-form">
                            <h2>Customer Information</h2>
                            <form method="POST" action="">
                                <div class="form-group">
                                    <label for="email">Email:</label>
                                    <input type="email" id="email" name="email" value="<?php echo isset($_SESSION['user_email']) ? $_SESSION['user_email'] : ''; ?>" required>
                                </div>
                                <div class="form-group">
                                    <label for="phone">Phone Number:</label>
                                    <input type="tel" id="phone" name="phone" required placeholder="Enter your phone number">
                                </div>
                                <div class="form-group">
                                    <label for="shipping_address">Shipping Address:</label>
                                    <textarea id="shipping_address" name="shipping_address" required placeholder="Enter your full shipping address"></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary">Place Order & Pay</button>
                            </form>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="empty-cart">
                        <h2>Your cart is empty</h2>
                        <p>Add some products to your cart before checkout!</p>
                        <a href="products.php" class="btn btn-primary">Browse Products</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <?php include 'includes/footer.php'; ?>

    <script src="assets/js/main.js"></script>
</body>
</html>