<?php
session_start();
require_once 'config/database.php';
require_once 'classes/Cart.php';
require_once 'includes/functions.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$database = new Database();
$db = $database->getConnection();
$cart = new Cart($db);

$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['update_quantity'])) {
        $cart->id = sanitizeInput($_POST['cart_id']);
        $cart->quantity = sanitizeInput($_POST['quantity']);
        if ($cart->updateQuantity()) {
            $message = 'Cart updated successfully';
        } else {
            $message = 'Failed to update cart';
        }
    } elseif (isset($_POST['remove_item'])) {
        $cart->id = sanitizeInput($_POST['cart_id']);
        if ($cart->removeFromCart()) {
            $message = 'Item removed from cart';
        } else {
            $message = 'Failed to remove item';
        }
    } elseif (isset($_POST['add_to_cart'])) {
        $cart->user_id = $_SESSION['user_id'];
        $cart->product_id = sanitizeInput($_POST['product_id']);
        $cart->quantity = sanitizeInput($_POST['quantity']);
        if ($cart->addToCart()) {
            $message = 'Item added to cart';
        } else {
            $message = 'Failed to add item to cart';
        }
    }
}

$cartItems = $cart->getCartItems($_SESSION['user_id']);
$cartTotal = $cart->getCartTotal($_SESSION['user_id']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shopping Cart - Internext</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <main>
        <div class="container">
            <div class="cart-page">
                <h1>Shopping Cart</h1>

                <?php if ($message): ?>
                    <div class="alert alert-success"><?php echo $message; ?></div>
                <?php endif; ?>

                <?php if ($cartItems->rowCount() > 0): ?>
                    <div class="cart-items">
                        <?php while ($item = $cartItems->fetch(PDO::FETCH_ASSOC)):
                            $images = json_decode($item['images'], true);
                            $firstImage = $images ? $images[0] : 'placeholder.jpg';
                        ?>
                            <div class="cart-item">
                                <img src="uploads/<?php echo $firstImage; ?>" alt="<?php echo $item['name']; ?>" onerror="this.src='assets/images/placeholder.jpg'">
                                <div class="item-details">
                                    <h3><?php echo $item['name']; ?></h3>
                                    <div class="price"><?php echo formatPrice($item['price']); ?></div>
                                </div>
                                <form method="POST" class="quantity-form">
                                    <input type="hidden" name="cart_id" value="<?php echo $item['id']; ?>">
                                    <input type="number" name="quantity" value="<?php echo $item['quantity']; ?>" min="1" max="99">
                                    <button type="submit" name="update_quantity" class="btn btn-small">Update</button>
                                </form>
                                <div class="item-total"><?php echo formatPrice($item['quantity'] * $item['price']); ?></div>
                                <form method="POST">
                                    <input type="hidden" name="cart_id" value="<?php echo $item['id']; ?>">
                                    <button type="submit" name="remove_item" class="btn btn-small btn-danger">Remove</button>
                                </form>
                            </div>
                        <?php endwhile; ?>
                    </div>

                    <div class="cart-summary">
                        <div class="total">
                            <strong>Total: <?php echo formatPrice($cartTotal); ?></strong>
                        </div>
                        <div class="cart-actions">
                            <a href="products.php" class="btn btn-secondary">Continue Shopping</a>
                            <a href="checkout.php" class="btn btn-primary">Proceed to Checkout</a>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="empty-cart">
                        <h2>Your cart is empty</h2>
                        <p>Add some products to your cart to get started!</p>
                        <a href="products.php" class="btn btn-primary">Browse Products</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <?php include 'includes/footer.php'; ?>

    <script src="assets/js/main.js"></script>
</body>
</html>