<?php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../classes/Wishlist.php';
require_once __DIR__ . '/../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not logged in']);
    exit();
}

$database = new Database();
$db = $database->getConnection();
$wishlist = new Wishlist($db);

$data = json_decode(file_get_contents('php://input'), true);

if (isset($data['product_id'])) {
    // Find wishlist item by user and product
    $query = "SELECT id FROM wishlist WHERE user_id = ? AND product_id = ?";
    $stmt = $db->prepare($query);
    $stmt->bindParam(1, $_SESSION['user_id']);
    $stmt->bindParam(2, $data['product_id']);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $wishlist->id = $row['id'];

        if ($wishlist->removeFromWishlist()) {
            echo json_encode(['success' => true, 'message' => 'Product removed from wishlist']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to remove product from wishlist']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Product not in wishlist']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
}
?>