<?php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../classes/Wishlist.php';
require_once __DIR__ . '/../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not logged in']);
    exit();
}

$database = new Database();
$db = $database->getConnection();
$wishlist = new Wishlist($db);

$data = json_decode(file_get_contents('php://input'), true);

if (isset($data['product_id'])) {
    $wishlist->user_id = $_SESSION['user_id'];
    $wishlist->product_id = sanitizeInput($data['product_id']);

    if ($wishlist->addToWishlist()) {
        echo json_encode(['success' => true, 'message' => 'Product added to wishlist']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to add product to wishlist']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
}
?>