<?php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../classes/Cart.php';
require_once __DIR__ . '/../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not logged in']);
    exit();
}

$database = new Database();
$db = $database->getConnection();
$cart = new Cart($db);

$data = json_decode(file_get_contents('php://input'), true);

if (isset($data['product_id']) && isset($data['quantity'])) {
    $cart->user_id = $_SESSION['user_id'];
    $cart->product_id = sanitizeInput($data['product_id']);
    $cart->quantity = sanitizeInput($data['quantity']);

    if ($cart->addToCart()) {
        echo json_encode(['success' => true, 'message' => 'Product added to cart']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to add product to cart']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
}
?>