<?php
session_start();
require_once '../config/database.php';
require_once '../includes/functions.php';

if (!isLoggedIn() || !isAdmin()) {
    redirect('../login.php');
}

$database = new Database();
$db = $database->getConnection();

// Get sales report
$salesQuery = "SELECT DATE(created_at) as date, SUM(total_amount) as total_sales, COUNT(*) as order_count FROM orders WHERE status != 'cancelled' GROUP BY DATE(created_at) ORDER BY date DESC LIMIT 30";
$salesStmt = $db->prepare($salesQuery);
$salesStmt->execute();

// Get product performance
$productQuery = "SELECT p.name, SUM(oi.quantity) as total_sold, SUM(oi.quantity * oi.price) as revenue FROM products p LEFT JOIN order_items oi ON p.id = oi.product_id GROUP BY p.id ORDER BY total_sold DESC LIMIT 10";
$productStmt = $db->prepare($productQuery);
$productStmt->execute();

// Get category performance
$categoryQuery = "SELECT c.name, COUNT(p.id) as product_count, SUM(oi.quantity) as total_sold FROM categories c LEFT JOIN products p ON c.id = p.category_id LEFT JOIN order_items oi ON p.id = oi.product_id GROUP BY c.id ORDER BY total_sold DESC";
$categoryStmt = $db->prepare($categoryQuery);
$categoryStmt->execute();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reports - Internext Admin</title>
    <link rel="stylesheet" href="../assets/css/admin.css">
</head>
<body>
    <div class="admin-container">
        <?php include 'sidebar.php'; ?>

        <div class="main-content">
            <header>
                <h1>Reports & Analytics</h1>
            </header>

            <div class="reports-grid">
                <div class="report-section">
                    <h2>Sales Report (Last 30 Days)</h2>
                    <table>
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Orders</th>
                                <th>Total Sales</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = $salesStmt->fetch(PDO::FETCH_ASSOC)): ?>
                                <tr>
                                    <td><?php echo $row['date']; ?></td>
                                    <td><?php echo $row['order_count']; ?></td>
                                    <td><?php echo formatPrice($row['total_sales']); ?></td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>

                <div class="report-section">
                    <h2>Top Selling Products</h2>
                    <table>
                        <thead>
                            <tr>
                                <th>Product</th>
                                <th>Units Sold</th>
                                <th>Revenue</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = $productStmt->fetch(PDO::FETCH_ASSOC)): ?>
                                <tr>
                                    <td><?php echo $row['name']; ?></td>
                                    <td><?php echo $row['total_sold'] ?: 0; ?></td>
                                    <td><?php echo formatPrice($row['revenue'] ?: 0); ?></td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>

                <div class="report-section">
                    <h2>Category Performance</h2>
                    <table>
                        <thead>
                            <tr>
                                <th>Category</th>
                                <th>Products</th>
                                <th>Units Sold</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = $categoryStmt->fetch(PDO::FETCH_ASSOC)): ?>
                                <tr>
                                    <td><?php echo $row['name']; ?></td>
                                    <td><?php echo $row['product_count']; ?></td>
                                    <td><?php echo $row['total_sold'] ?: 0; ?></td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</body>
</html>