<?php
session_start();
require_once '../config/config.php';
require_once '../config/database.php';
require_once '../classes/Order.php';
require_once '../classes/OrderItem.php';
require_once '../includes/functions.php';
require_once '../vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

function sendOrderStatusEmail($userEmail, $orderId, $status) {
    // Validate email
    if (empty($userEmail) || !filter_var($userEmail, FILTER_VALIDATE_EMAIL)) {
        error_log("Email Error: Invalid or missing user email address for order_id=$orderId");
        return false;
    }

    // Initialize PHPMailer with debugging
    $mail = new PHPMailer(true);
    $mail->SMTPDebug = 2; // Enable verbose debug output (set to 0 in production)
    $mail->Debugoutput = function($str, $level) {
        error_log("PHPMailer Debug [$level]: $str");
    };
    $mail->isSMTP();
    $mail->Host = 'mail.internext.co.ke';
    $mail->SMTPAuth = true;
    $mail->Username = 'corezap@internext.co.ke';
    $mail->Password = defined('EMAIL_PASSWORD') ? EMAIL_PASSWORD : 'Moris@32908899#90'; // Use constant or env variable
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
    $mail->Port = 465;

    try {
        // Recipients
        $mail->setFrom('corezap@internext.co.ke', SITE_NAME);
        $mail->addAddress($userEmail);

        // Content
        $mail->isHTML(true);
        $mail->Subject = 'Order Status Update - ' . SITE_NAME;
        $mail->Body = "
            <html>
            <head>
                <style>
                    body { font-family: Arial, sans-serif; }
                    .container { width: 100%; max-width: 600px; margin: 0 auto; }
                    .header { background: #f8f8f8; padding: 20px; text-align: center; border-radius: 5px 5px 0 0; }
                    .content { padding: 20px; background: #ffffff; border: 1px solid #e0e0e0; }
                    .status-box { background: #e8f5e8; border: 1px solid #4caf50; padding: 15px; margin: 20px 0; border-radius: 5px; }
                    .footer { background: #f8f8f8; padding: 15px; text-align: center; border-radius: 0 0 5px 5px; border: 1px solid #e0e0e0; border-top: none; }
                    .status-text { font-size: 18px; font-weight: bold; color: #2e7d32; }
                </style>
            </head>
            <body>
                <div class='container'>
                    <div class='header'>
                        <h2>Order Status Update</h2>
                    </div>
                    <div class='content'>
                        <p>Dear Customer,</p>
                        <p>We are writing to inform you about an update to your order.</p>
                        <div class='status-box'>
                            <p><strong>Order ID:</strong> #$orderId</p>
                            <p><strong>New Status:</strong> <span class='status-text'>" . ucfirst($status) . "</span></p>
                        </div>
                        <p>Thank you for shopping with us! If you have any questions about your order, please don't hesitate to contact our customer service team.</p>
                        <p>Best regards,<br>" . SITE_NAME . " Team</p>
                    </div>
                    <div class='footer'>
                        <p>This is an automated message. Please do not reply to this email.</p>
                    </div>
                </div>
            </body>
            </html>";

        $mail->AltBody = "Dear Customer,\n\nYour order #$orderId status has been updated to: " . ucfirst($status) . ".\n\nThank you for shopping with us!\n\nBest regards,\n" . SITE_NAME . " Team";

        $mail->send();
        error_log("Email Sent: order_id=$orderId, user_email=$userEmail, status=$status");
        return true;
    } catch (Exception $e) {
        error_log("Email Error: " . $e->getMessage() . " | order_id=$orderId | user_email=$userEmail | Mailer Error: {$mail->ErrorInfo}");
        return false;
    }
}

if (!isLoggedIn() || !isAdmin()) {
    redirect('../login.php');
}

$database = new Database();
$db = $database->getConnection();
$order = new Order($db);
$orderItem = new OrderItem($db);

$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_status'])) {
    $order->id = sanitizeInput($_POST['order_id']);
    $order->status = sanitizeInput($_POST['status']);

    if ($order->update()) {
        // Fetch order details to get user email
        $order->readOne();
        $userEmail = $order->email;
        $orderId = $order->id;
        $newStatus = $order->status;

        // Send email notification
        if (sendOrderStatusEmail($userEmail, $orderId, $newStatus)) {
            $message = 'Order status updated successfully and email notification sent.';
        } else {
            $message = 'Order status updated successfully, but failed to send email notification.';
        }
    } else {
        $message = 'Failed to update order status';
    }
}

$orders = $order->read();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Management - Internext Admin</title>
    <link rel="stylesheet" href="../assets/css/admin.css">
</head>
<body>
    <div class="admin-container">
        <?php include 'sidebar.php'; ?>

        <div class="main-content">
            <header>
                <h1>Order Management</h1>
            </header>

            <?php if ($message): ?>
                <div class="alert alert-success"><?php echo $message; ?></div>
            <?php endif; ?>

            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Order ID</th>
                            <th>Customer</th>
                            <th>Total Amount</th>
                            <th>Status</th>
                            <th>Payment Ref</th>
                            <th>Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $orders->fetch(PDO::FETCH_ASSOC)): ?>
                            <tr>
                                <td><?php echo $row['id']; ?></td>
                                <td><?php echo $row['user_name']; ?></td>
                                <td><?php echo formatPrice($row['total_amount']); ?></td>
                                <td>
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="order_id" value="<?php echo $row['id']; ?>">
                                        <select name="status" onchange="this.form.submit()">
                                            <option value="pending" <?php echo $row['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                                            <option value="processing" <?php echo $row['status'] == 'processing' ? 'selected' : ''; ?>>Processing</option>
                                            <option value="shipped" <?php echo $row['status'] == 'shipped' ? 'selected' : ''; ?>>Shipped</option>
                                            <option value="delivered" <?php echo $row['status'] == 'delivered' ? 'selected' : ''; ?>>Delivered</option>
                                            <option value="cancelled" <?php echo $row['status'] == 'cancelled' ? 'selected' : ''; ?>>Cancelled</option>
                                        </select>
                                        <input type="hidden" name="update_status" value="1">
                                    </form>
                                </td>
                                <td><?php echo $row['payment_reference'] ?: 'N/A'; ?></td>
                                <td><?php echo date('Y-m-d H:i', strtotime($row['created_at'])); ?></td>
                                <td>
                                    <a href="order_details.php?id=<?php echo $row['id']; ?>" class="btn btn-small">View Details</a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>