<?php
session_start();
require_once '../config/database.php';
require_once '../classes/Order.php';
require_once '../classes/OrderItem.php';
require_once '../includes/functions.php';

if (!isLoggedIn() || !isAdmin()) {
    redirect('../login.php');
}

$database = new Database();
$db = $database->getConnection();
$order = new Order($db);
$orderItem = new OrderItem($db);

if (!isset($_GET['id'])) {
    redirect('orders.php');
}

$order->id = $_GET['id'];
$order->readOne();
$orderItems = $orderItem->getOrderItems($order->id);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Details - Internext Admin</title>
    <link rel="stylesheet" href="../assets/css/admin.css">
</head>
<body>
    <div class="admin-container">
        <?php include 'sidebar.php'; ?>

        <div class="main-content">
            <header>
                <h1>Order Details #<?php echo $order->id; ?></h1>
                <a href="orders.php" class="btn btn-secondary">Back to Orders</a>
            </header>

            <div class="order-details">
                <div class="order-info">
                    <h2>Order Information</h2>
                    <p><strong>Order ID:</strong> <?php echo $order->id; ?></p>
                    <p><strong>User:</strong> <?php echo $order->user_name; ?></p>
                    <p><strong>Email:</strong> <?php echo $order->email; ?></p>
                    <p><strong>Phone:</strong> <?php echo $order->phone; ?></p>
                    <p><strong>Total Amount:</strong> <?php echo formatPrice($order->total_amount); ?></p>
                    <p><strong>Status:</strong> <?php echo ucfirst($order->status); ?></p>
                    <p><strong>Payment Reference:</strong> <?php echo $order->payment_reference ?: 'N/A'; ?></p>
                    <p><strong>Shipping Address:</strong> <?php echo $order->shipping_address; ?></p>
                    <p><strong>Order Date:</strong> <?php echo date('Y-m-d H:i:s', strtotime($order->created_at)); ?></p>
                </div>

                <div class="order-items">
                    <h2>Order Items</h2>
                    <table>
                        <thead>
                            <tr>
                                <th>Product</th>
                                <th>Quantity</th>
                                <th>Price</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($item = $orderItems->fetch(PDO::FETCH_ASSOC)): ?>
                                <tr>
                                    <td><?php echo $item['name']; ?></td>
                                    <td><?php echo $item['quantity']; ?></td>
                                    <td><?php echo formatPrice($item['price']); ?></td>
                                    <td><?php echo formatPrice($item['quantity'] * $item['price']); ?></td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</body>
</html>