<?php
session_start();
require_once '../config/database.php';
require_once '../classes/Category.php';
require_once '../includes/functions.php';

if (!isLoggedIn() || !isAdmin()) {
    redirect('../login.php');
}

$database = new Database();
$db = $database->getConnection();
$category = new Category($db);

$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['create'])) {
        $category->name = sanitizeInput($_POST['name']);
        $category->description = sanitizeInput($_POST['description']);

        if ($category->create()) {
            $message = 'Category created successfully';
        } else {
            $message = 'Failed to create category';
        }
    } elseif (isset($_POST['update'])) {
        $category->id = sanitizeInput($_POST['id']);
        $category->name = sanitizeInput($_POST['name']);
        $category->description = sanitizeInput($_POST['description']);

        if ($category->update()) {
            $message = 'Category updated successfully';
        } else {
            $message = 'Failed to update category';
        }
    } elseif (isset($_POST['delete'])) {
        $category->id = sanitizeInput($_POST['id']);
        if ($category->delete()) {
            $message = 'Category deleted successfully';
        } else {
            $message = 'Failed to delete category';
        }
    }
}

$categories = $category->read();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Category Management - Internext Admin</title>
    <link rel="stylesheet" href="../assets/css/admin.css">
</head>
<body>
    <div class="admin-container">
        <?php include 'sidebar.php'; ?>

        <div class="main-content">
            <header>
                <h1>Category Management</h1>
                <button class="btn btn-primary" onclick="showCreateForm()">Add New Category</button>
            </header>

            <?php if ($message): ?>
                <div class="alert alert-success"><?php echo $message; ?></div>
            <?php endif; ?>

            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $categories->fetch(PDO::FETCH_ASSOC)): ?>
                            <tr>
                                <td><?php echo $row['id']; ?></td>
                                <td><?php echo $row['name']; ?></td>
                                <td><?php echo $row['description']; ?></td>
                                <td>
                                    <button class="btn btn-small" onclick="editCategory(<?php echo $row['id']; ?>)">Edit</button>
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                        <button type="submit" name="delete" class="btn btn-small btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>

            <!-- Create/Edit Category Modal -->
            <div id="categoryModal" class="modal">
                <div class="modal-content">
                    <span class="close" onclick="closeModal()">&times;</span>
                    <h2 id="modalTitle">Add New Category</h2>
                    <form id="categoryForm" method="POST">
                        <input type="hidden" name="id" id="categoryId">
                        <div class="form-group">
                            <label for="name">Name:</label>
                            <input type="text" id="name" name="name" required>
                        </div>
                        <div class="form-group">
                            <label for="description">Description:</label>
                            <textarea id="description" name="description" required></textarea>
                        </div>
                        <button type="submit" name="create" id="submitBtn" class="btn btn-primary">Create Category</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        function showCreateForm() {
            document.getElementById('modalTitle').textContent = 'Add New Category';
            document.getElementById('categoryForm').reset();
            document.getElementById('categoryId').value = '';
            document.getElementById('submitBtn').name = 'create';
            document.getElementById('categoryModal').style.display = 'block';
        }

        function editCategory(id) {
            // Fetch category data and populate form
            fetch(`get_category.php?id=${id}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('modalTitle').textContent = 'Edit Category';
                    document.getElementById('categoryId').value = data.id;
                    document.getElementById('name').value = data.name;
                    document.getElementById('description').value = data.description;
                    document.getElementById('submitBtn').name = 'update';
                    document.getElementById('categoryModal').style.display = 'block';
                });
        }

        function closeModal() {
            document.getElementById('categoryModal').style.display = 'none';
        }
    </script>
</body>
</html>