# Internext - Online Shopping System

A comprehensive e-commerce platform built with PHP, JavaScript, HTML, and CSS featuring Paystack payment integration.

## Features

### User Features
- User registration and authentication
- Product browsing and search
- Shopping cart functionality
- Wishlist management
- Secure checkout process
- Paystack payment integration
- Order history and tracking

### Admin Features
- Admin dashboard with statistics
- Product management (CRUD with multiple images)
- Category management
- Order management and status updates
- Sales reporting and analytics
- User management

### Technical Features
- Responsive design
- Multiple product images support
- AJAX-powered cart and wishlist
- Secure payment processing
- Database-driven architecture

## Installation

1. **Prerequisites**
   - XAMPP or similar PHP development environment
   - MySQL database
   - Paystack account for payment processing

2. **Setup**
   - Clone or download the project to your XAMPP htdocs directory
   - Import the `internext.sql` file into your MySQL database
   - Update database credentials in `config/database.php`
   - Configure Paystack keys in `config/config.php`

3. **Configuration**
   - Update Paystack public and secret keys in `config/config.php`
   - Ensure the `uploads/` directory is writable
   - Configure your web server to point to the project directory

## Database Setup

Run the following SQL commands to set up the database:

```sql
-- Import the internext.sql file
mysql -u root -p < internext.sql
```

Or manually create the database and import through phpMyAdmin.

## Usage

### For Users
1. Register an account or login
2. Browse products by category or search
3. Add items to cart or wishlist
4. Proceed to checkout
5. Complete payment via Paystack
6. Track order status

### For Admins
1. Login with admin credentials (admin@internext.com / password)
2. Access admin dashboard at `/admin/dashboard.php`
3. Manage products, categories, and orders
4. View sales reports and analytics

## File Structure

```
internext/
├── admin/                 # Admin panel files
├── api/                   # AJAX API endpoints
├── assets/                # CSS, JS, and static files
├── classes/               # PHP classes
├── config/                # Configuration files
├── includes/              # Reusable components
├── uploads/               # Product images
├── index.php             # Homepage
├── login.php             # User login
├── register.php          # User registration
├── products.php          # Product catalog
├── product.php           # Product details
├── cart.php              # Shopping cart
├── wishlist.php          # User wishlist
├── checkout.php          # Checkout process
├── payment.php           # Payment processing
├── orders.php            # Order history
├── README.md             # This file
└── internext.sql         # Database schema
```

## Paystack Integration

1. Sign up for a Paystack account
2. Get your public and secret keys
3. Update the keys in `config/config.php`
4. Test payments in test mode
5. Switch to live mode for production

## Security Features

- Password hashing with bcrypt
- SQL injection prevention with prepared statements
- XSS protection with input sanitization
- Session-based authentication
- File upload validation

## Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Test thoroughly
5. Submit a pull request

## License

This project is open source and available under the MIT License.

## Support

For support or questions, please contact the development team or create an issue in the repository.